# 🔄 Guide de mise à jour - WEBFUL Analytics v1.1.0

## ✅ Bonne nouvelle : AUCUNE perte de données !

Vos identifiants WEBFUL et toute votre configuration sont **automatiquement préservés** lors de la mise à jour. Aucune reconnexion nécessaire !

---

## 📋 Procédure de mise à jour (2 minutes)

### Étape 1️⃣ : Télécharger la nouvelle version
- Connectez-vous à votre compte WEBFUL
- Allez dans **Mon compte → Téléchargements**
- Téléchargez le fichier `webful-wordpress-plugin.zip` (version 1.1.0)

### Étape 2️⃣ : Installer la nouvelle version
- Dans WordPress, allez dans **Extensions → Ajouter → Téléverser une extension**
- Cliquez sur **"Choisir un fichier"**
- Sélectionnez `webful-wordpress-plugin.zip` (v1.1.0)
- Cliquez sur **"Installer maintenant"**

### Étape 3️⃣ : Écraser l'ancienne version
- WordPress détecte que le plugin existe déjà
- **Cliquez sur "Remplacer l'extension actuelle"**
- WordPress écrase les fichiers sans toucher à vos données

### Étape 4️⃣ : Vérifier
- La page se recharge automatiquement
- Vos identifiants et paramètres sont **intacts**
- Allez dans le menu **WEBFUL** de WordPress
- Vérifiez que le statut indique **"✅ Site connecté"**
- Vérifiez que la version est **1.1.0**

✅ **C'est terminé !** Aucune reconnexion, tout fonctionne immédiatement.

---

## ⚡ Méthode rapide (utilisateurs avancés)

Si vous avez accès à votre serveur par FTP/SFTP :

```bash
1. Connectez-vous à votre serveur
2. Allez dans : /wp-content/plugins/webful/assets/js/
3. Remplacez webful-tracker.js par la nouvelle version
4. Videz le cache WordPress (si plugin de cache installé)
```

✅ Terminé ! Le tracker filtre maintenant les referrers internes.

---

## 🔍 Comment vérifier que la mise à jour a fonctionné ?

### Méthode 1 : Version du plugin
- Dans WordPress → Extensions
- Cherchez "WEBFUL Analytics"
- Vérifiez que la version est **1.1.0**

### Méthode 2 : Code source de la page
- Affichez une page de votre site
- Faites clic droit → Afficher le code source
- Recherchez `webful-tracker.js`
- Le fichier doit contenir la fonction `getExternalReferrer`

### Méthode 3 : Console navigateur
- Ouvrez la console JavaScript (F12)
- Naviguez sur votre site (ex: Accueil → Page 2 → Page 3)
- Dans l'onglet Réseau, vérifiez les requêtes à l'API Webful
- Le champ `referrer` doit être `null` pour les navigations internes

---

## ❓ FAQ Mise à jour

### Q : Vais-je perdre mes statistiques ?
**R :** Non ! Les statistiques sont stockées sur les serveurs WEBFUL, pas dans le plugin.

### Q : Vais-je perdre mes identifiants ?
**R :** Non ! Les identifiants sont stockés dans la base de données WordPress (table `wp_options`).

### Q : Vais-je perdre mes paramètres ?
**R :** Non ! Les paramètres (tracking activé, exclusion admin, etc.) sont stockés en base de données.

### Q : Dois-je re-connecter mon site ?
**R :** Non ! La reconnexion est automatique après activation.

### Q : Combien de temps dure la mise à jour ?
**R :** 2-3 minutes maximum.

### Q : Que se passe-t-il pendant la mise à jour ?
**R :** Le tracking est interrompu pendant 1-2 minutes le temps de la mise à jour. Aucune visite ne sera perdue, juste non trackée pendant ce court instant.

### Q : Puis-je revenir à la version 1.0.0 ?
**R :** Oui, en réinstallant l'ancien ZIP. Mais la v1.1.0 apporte uniquement des améliorations, aucun inconvénient.

---

## 🆘 Support

Problème avec la mise à jour ?
- Email : support@webful.fr
- Documentation : webful.fr/documentation
- Dashboard : webful.fr/dashboard

---

**Dernière mise à jour de ce guide : 23 janvier 2025**
