/**
 * WEBFUL Analytics - Script Admin
 * Version: 1.0.0
 */

(function($) {
    'use strict';

    /**
     * Afficher un message
     */
    function showMessage(container, message, type) {
        var $container = $(container);
        $container
            .removeClass('success error info')
            .addClass(type)
            .html(message)
            .fadeIn();

        // Masquer après 5 secondes sauf pour les erreurs
        if (type !== 'error') {
            setTimeout(function() {
                $container.fadeOut();
            }, 5000);
        }
    }

    /**
     * Formulaire de connexion
     */
    $('#webful-connect-form').on('submit', function(e) {
        e.preventDefault();

        var $form = $(this);
        var $submitBtn = $form.find('button[type="submit"]');
        var originalText = $submitBtn.text();

        // Désactiver le bouton
        $submitBtn.prop('disabled', true).text(webfulAdmin.i18n.connecting);

        // Récupérer les données
        var formData = {
            action: 'webful_connect',
            nonce: webfulAdmin.nonce,
            email: $('#webful_email').val(),
            password: $('#webful_password').val()
        };

        // Envoyer la requête AJAX
        $.post(webfulAdmin.ajaxUrl, formData)
            .done(function(response) {
                if (response.success) {
                    showMessage('#webful-message', response.data.message, 'success');

                    // Recharger la page après 1 seconde
                    setTimeout(function() {
                        window.location.reload();
                    }, 1000);
                } else {
                    showMessage('#webful-message', response.data.message, 'error');
                    $submitBtn.prop('disabled', false).text(originalText);
                }
            })
            .fail(function() {
                showMessage('#webful-message', 'Erreur de connexion au serveur', 'error');
                $submitBtn.prop('disabled', false).text(originalText);
            });
    });

    /**
     * Bouton de déconnexion
     */
    $('#webful-disconnect-btn').on('click', function() {
        if (!confirm('Êtes-vous sûr de vouloir déconnecter ce site de WEBFUL ?')) {
            return;
        }

        var $btn = $(this);
        var originalText = $btn.text();

        $btn.prop('disabled', true).text(webfulAdmin.i18n.disconnecting);

        $.post(webfulAdmin.ajaxUrl, {
            action: 'webful_disconnect',
            nonce: webfulAdmin.nonce
        })
            .done(function(response) {
                if (response.success) {
                    // Recharger la page
                    window.location.reload();
                } else {
                    alert(response.data.message);
                    $btn.prop('disabled', false).text(originalText);
                }
            })
            .fail(function() {
                alert('Erreur de connexion au serveur');
                $btn.prop('disabled', false).text(originalText);
            });
    });

    /**
     * Formulaire de paramètres
     */
    $('#webful-settings-form').on('submit', function(e) {
        e.preventDefault();

        var $form = $(this);
        var $submitBtn = $form.find('button[type="submit"]');
        var originalText = $submitBtn.text();

        $submitBtn.prop('disabled', true).text(webfulAdmin.i18n.saving);

        var formData = {
            action: 'webful_save_settings',
            nonce: webfulAdmin.nonce,
            tracking_enabled: $('#webful_tracking_enabled').is(':checked') ? '1' : '0',
            check_quota: $('#webful_check_quota').is(':checked') ? '1' : '0',
            exclude_admins: $('#webful_exclude_admins').is(':checked') ? '1' : '0',
            excluded_pages: $('#webful_excluded_pages').val()
        };

        $.post(webfulAdmin.ajaxUrl, formData)
            .done(function(response) {
                if (response.success) {
                    showMessage('#webful-settings-message', response.data.message, 'success');
                } else {
                    showMessage('#webful-settings-message', response.data.message, 'error');
                }
                $submitBtn.prop('disabled', false).text(originalText);
            })
            .fail(function() {
                showMessage('#webful-settings-message', 'Erreur de connexion au serveur', 'error');
                $submitBtn.prop('disabled', false).text(originalText);
            });
    });

    /**
     * Actualiser le quota
     */
    $('#webful-refresh-quota').on('click', function() {
        var $btn = $(this);
        var originalHtml = $btn.html();

        $btn.prop('disabled', true).html('<span class="dashicons dashicons-update"></span> ' + webfulAdmin.i18n.checking);

        $.post(webfulAdmin.ajaxUrl, {
            action: 'webful_check_quota',
            nonce: webfulAdmin.nonce
        })
            .done(function(response) {
                if (response.success) {
                    // Recharger la page pour afficher le nouveau quota
                    window.location.reload();
                } else {
                    alert(response.data.message);
                    $btn.prop('disabled', false).html(originalHtml);
                }
            })
            .fail(function() {
                alert('Erreur de connexion au serveur');
                $btn.prop('disabled', false).html(originalHtml);
            });
    });

})(jQuery);
